path "D:\\BIN\\GSTUDIO6\\template";	// Path to WDL templates subdirectory
include <movement.wdl>;
var video_mode = 6;	 // screen size 640x480
var video_depth = 16; // 16 bit colour D3D mode
string level_str=<Rings.wmb>;

function main()
{
	level_load(level_str);
}

var some_distance=2000;

//Scaling
var max_scale=2;
var min_scale=1;
var scale_gap=1;
var scale_speed=.1;
define scale_direction, skill1;
var current_scale=1;
//Lights
var max_range=200;
var min_range=100;
var range_gap;


action core()
{
	me.transparent=on;
	me.alpha=60;
	me.flare=on;
	me.scale_direction=1;
	me.skin=2;
	
	scale_gap=max_scale-min_scale;
	range_gap=max_range-min_range;
	
	while(1)
	{
		current_scale=me.scale_x;
		if(me.scale_x>max_scale)		//Is it too big?
			{me.scale_direction=-1;}	//Yes, so we now scale it negatively
		if(me.scale_x<min_scale)		//To small?
			{me.scale_direction=1;}	//Yes, so we scale it bigger
		me.scale_x += me.scale_direction * scale_speed * time;	//+= means add to
		me.scale_y += me.scale_direction * scale_speed * time;
		me.scale_z += me.scale_direction * scale_speed * time;
			
		//if(vec_dist(player.x,me.x)<some_distance)
		//{
			me.lightrange=range_gap*(me.scale_x-min_scale)/scale_gap+min_range;
		//}
		
		wait(1);				//Wait one frame and then do it agan
	}	
}

var FF_max_scale=1.2;
var FF_min_scale=1;
var FF_scale_gap;
define original_scale,skill1;
var tmpScale;

action Force_Field()
{
	me.transparent=on;
	me.alpha=10;
	me.flare=on;
	me.ambient=10;
	me.skin=1;
	FF_scale_gap=FF_max_scale-FF_min_scale;
	me.original_scale=me.scale_x;
	while(1)
	{
		tmpScale = FF_scale_gap * (1 - (current_scale-min_scale)/scale_gap) + FF_min_scale;
		tmpScale = tmpScale * me.original_scale;
		me.scale_x = tmpScale;
		me.scale_y = tmpScale;
		me.scale_z = tmpScale;
		wait(1);
	}
}

function make_look_good()
{
	me.shadow=on;
	me.transparent=on;
	me.alpha=45;
}

var speed=2;

action rotate_1()
{
	make_look_good();
	while(1)
	{
		me.roll+=speed*time;
		me.pan+=(speed+.2)*time;
		wait(1);
	}
}

action rotate_2()
{
	make_look_good();
	while(1)
	{
		me.roll+=(speed+.2)*time;
		me.tilt+=speed*time;
		wait(1);
	}
}

action rotate_3()
{
	make_look_good();
	while(1)
	{
		me.pan+=speed*time;
		me.tilt+=(speed+.2)*time;
		wait(1);
	}
}